﻿
--------------------------------------------------------
-- ROLES

-- delete link table entries
DELETE FROM RoleAction
DELETE FROM UserRole

-- delete main table entries
DELETE FROM Action
DELETE FROM Role

SET IDENTITY_INSERT [dbo].[Role] ON
INSERT INTO Role (Id, RoleName) VALUES(1, 'Administrator');
INSERT INTO Role (Id, RoleName) VALUES(2, 'Scheduler');
--INSERT INTO Role (Id, RoleName) VALUES(3, 'Check-In');
INSERT INTO [dbo].[Role] ([Id], [RoleName]) VALUES (9, N'FrontDesk')

-- user with all access but no overbook
INSERT INTO [dbo].[Role] ([Id], [RoleName]) VALUES (10, N'NoOverbook')

SET IDENTITY_INSERT [dbo].[Role] OFF

--------------------------------------------------------
-- USERS IN ROLES - Administrators

SET IDENTITY_INSERT [dbo].[UserRole] ON
INSERT INTO UserRole (Id, RoleId, UserId) VALUES (1,1,1);
INSERT INTO UserRole (Id, RoleId, UserId) VALUES (2,1,2);
INSERT INTO UserRole (Id, RoleId, UserId) VALUES (3,1,3);
INSERT INTO UserRole (Id, RoleId, UserId) VALUES (4,1,4);
INSERT INTO UserRole (Id, RoleId, UserId) VALUES (5,1,5);
INSERT INTO UserRole (Id, RoleId, UserId) VALUES (6,1,6);
INSERT INTO UserRole (Id, RoleId, UserId) VALUES (7,1,11);
INSERT INTO UserRole (Id, RoleId, UserId) VALUES (8,1,12);
INSERT INTO UserRole (Id, RoleId, UserId) VALUES (9,1,13);

-- Front Desk Role for demo
INSERT INTO [dbo].[UserRole] ([Id], [UserId], [RoleId], [SiteId], [SectionId]) VALUES (36, 24, 9, NULL, NULL)

-- user with all access but no overbook
INSERT INTO [dbo].[UserRole] ([Id], [UserId], [RoleId], [SiteId], [SectionId]) VALUES (37, 25, 10, NULL, NULL)
SET IDENTITY_INSERT [dbo].[UserRole] OFF

--------------------------------------------------------
DELETE FROM Action

SET IDENTITY_INSERT [dbo].[Action] ON

-- Action key is "ActionArea|ActionId". The Action area defines what the Action Id will be
-- E.g. for menu access, Action area is menu and the id is the integer id of the menu item
-- Example "menu|2"
-- For access to functionality, the use case is "action|CanPerformCheckIn"
-- values are caase insensitive

-- INSERT INTO Action (Id, ActionName, ActionDesc, ActionKey) Values (1, 'Action 1','Action 1','Action 1');


INSERT INTO [dbo].[Action] ([Id], [ActionKey], [ActionName], [ActionDesc]) VALUES (2, N'menu|2', N'Access to menu VistA', N'Menu item VistA')
INSERT INTO [dbo].[Action] ([Id], [ActionKey], [ActionName], [ActionDesc]) VALUES (3, N'menu|3', N'Access to menu Appointments', N'Menu item Appointments')
INSERT INTO [dbo].[Action] ([Id], [ActionKey], [ActionName], [ActionDesc]) VALUES (4, N'menu|4', N'Access to menu Administration', N'Menu item Administration')
--INSERT INTO [dbo].[Action] ([Id], [ActionKey], [ActionName], [ActionDesc]) VALUES (5, N'menu|5', N'Access to menu Template Admin', N'Menu item Template Admin')
INSERT INTO [dbo].[Action] ([Id], [ActionKey], [ActionName], [ActionDesc]) VALUES (6, N'menu|6', N'Access to menu About', N'~/About.aspx')
INSERT INTO [dbo].[Action] ([Id], [ActionKey], [ActionName], [ActionDesc]) VALUES (7, N'menu|7', N'Access to menu Help', N'~/Help.aspx')
INSERT INTO [dbo].[Action] ([Id], [ActionKey], [ActionName], [ActionDesc]) VALUES (8, N'menu|8', N'Access to menu Sites', N'~/Administration/SiteList.aspx')
INSERT INTO [dbo].[Action] ([Id], [ActionKey], [ActionName], [ActionDesc]) VALUES (9, N'menu|9', N'Access to menu Facilities', N'~/Administration/FacilityList.aspx')

INSERT INTO [dbo].[Action] ([Id], [ActionKey], [ActionName], [ActionDesc]) VALUES (11, N'menu|11', N'Access to menu Patient Appointments', N'~/Patient/PatientAppointmentList.aspx')
INSERT INTO [dbo].[Action] ([Id], [ActionKey], [ActionName], [ActionDesc]) VALUES (12, N'menu|12', N'Access to menu Group Appointments', N'~/Patient/GroupAppointmentsList.aspx')
--INSERT INTO [dbo].[Action] ([Id], [ActionKey], [ActionName], [ActionDesc]) VALUES (24, N'menu|24', N'Access to menu Appointment Resources', N'~/Patient/ResourceView.aspx')

INSERT INTO [dbo].[Action] ([Id], [ActionKey], [ActionName], [ActionDesc]) VALUES (25, N'menu|25', N'Access to menu Walk-in Appointment', N'~/Patient/PatientAppointmentAddWalkIn.aspx')

INSERT INTO [dbo].[Action] ([Id], [ActionKey], [ActionName], [ActionDesc]) VALUES (26, N'menu|26', N'Access to menu Provider Roster', N'~/Patient/ProviderRoster.aspx')
INSERT INTO [dbo].[Action] ([Id], [ActionKey], [ActionName], [ActionDesc]) VALUES (30, N'menu|30', N'Access to menu Tele-Health', N'~/Patient/TeleHealth.aspx')


INSERT INTO [dbo].[Action] ([Id], [ActionKey], [ActionName], [ActionDesc]) VALUES (15, N'menu|15', N'Access to menu Patient Check-In', N'~/Patient/PatientCheckIn.aspx')
INSERT INTO [dbo].[Action] ([Id], [ActionKey], [ActionName], [ActionDesc]) VALUES (16, N'menu|16', N'Access to menu Waiting Lists', N'~/Patient/WaitingList.aspx')
INSERT INTO [dbo].[Action] ([Id], [ActionKey], [ActionName], [ActionDesc]) VALUES (40, N'menu|40', N'Access to menu Clinic Schedule', N'~/Patient/ClinicSchedule.aspx')
--INSERT INTO [dbo].[Action] ([Id], [ActionKey], [ActionName], [ActionDesc]) VALUES (17, N'menu|17', N'Access to menu Resources', N'~/Administration/Resources/ResourceList.aspx')
INSERT INTO [dbo].[Action] ([Id], [ActionKey], [ActionName], [ActionDesc]) VALUES (18, N'menu|18', N'Access to menu Users', N'~/Administration/Users/Users.aspx')
INSERT INTO [dbo].[Action] ([Id], [ActionKey], [ActionName], [ActionDesc]) VALUES (19, N'menu|19', N'Access to menu Roles', N'~/Administration/Users/Roles.aspx')
INSERT INTO [dbo].[Action] ([Id], [ActionKey], [ActionName], [ActionDesc]) VALUES (20, N'menu|20', N'Access to menu Users in Roles', N'~/Administration/Users/UsersInRoles.aspx')
INSERT INTO [dbo].[Action] ([Id], [ActionKey], [ActionName], [ActionDesc]) VALUES (21, N'menu|21', N'Access to menu Actions', N'~/Administration/Users/Actions.aspx')
INSERT INTO [dbo].[Action] ([Id], [ActionKey], [ActionName], [ActionDesc]) VALUES (22, N'menu|22', N'Access to menu Role Actions', N'~/Administration/Users/RoleActions.aspx')
--INSERT INTO [dbo].[Action] ([Id], [ActionKey], [ActionName], [ActionDesc]) VALUES (23, N'menu|23', N'Access to menu Templates', N'~/Administration/Templates/TemplateList.aspx')
INSERT INTO [dbo].[Action] ([Id], [ActionKey], [ActionName], [ActionDesc]) VALUES (50, N'menu|50', N'Access to Reports', N'!Reports')


INSERT INTO [dbo].[Action] ([Id], [ActionKey], [ActionName], [ActionDesc]) VALUES (100, N'action|CanOverbookAppointment', N'Overbook Appointment', N'Action that allows overbooking of an appointment')


SET IDENTITY_INSERT [dbo].[Action] OFF

---------------------------------------------------


SET IDENTITY_INSERT [dbo].[RoleAction] ON
-- roles for front desk (check-in only)
INSERT INTO [dbo].[RoleAction] ([Id], [RoleId], [ActionId]) VALUES (305, 9, 6)
INSERT INTO [dbo].[RoleAction] ([Id], [RoleId], [ActionId]) VALUES (306, 9, 3)
INSERT INTO [dbo].[RoleAction] ([Id], [RoleId], [ActionId]) VALUES (307, 9, 15)
INSERT INTO [dbo].[RoleAction] ([Id], [RoleId], [ActionId]) VALUES (542, 9, 25)

-- user with all access but no overbook
INSERT INTO [dbo].[RoleAction] ([Id], [RoleId], [ActionId]) VALUES (518, 10, 6)
INSERT INTO [dbo].[RoleAction] ([Id], [RoleId], [ActionId]) VALUES (519, 10, 21)
INSERT INTO [dbo].[RoleAction] ([Id], [RoleId], [ActionId]) VALUES (520, 10, 4)
--INSERT INTO [dbo].[RoleAction] ([Id], [RoleId], [ActionId]) VALUES (521, 10, 24)
INSERT INTO [dbo].[RoleAction] ([Id], [RoleId], [ActionId]) VALUES (522, 10, 3)
INSERT INTO [dbo].[RoleAction] ([Id], [RoleId], [ActionId]) VALUES (523, 10, 40)
INSERT INTO [dbo].[RoleAction] ([Id], [RoleId], [ActionId]) VALUES (524, 10, 9)
INSERT INTO [dbo].[RoleAction] ([Id], [RoleId], [ActionId]) VALUES (525, 10, 12)
INSERT INTO [dbo].[RoleAction] ([Id], [RoleId], [ActionId]) VALUES (526, 10, 7)
INSERT INTO [dbo].[RoleAction] ([Id], [RoleId], [ActionId]) VALUES (527, 10, 11)
INSERT INTO [dbo].[RoleAction] ([Id], [RoleId], [ActionId]) VALUES (528, 10, 15)
INSERT INTO [dbo].[RoleAction] ([Id], [RoleId], [ActionId]) VALUES (529, 10, 26)
INSERT INTO [dbo].[RoleAction] ([Id], [RoleId], [ActionId]) VALUES (530, 10, 22)
INSERT INTO [dbo].[RoleAction] ([Id], [RoleId], [ActionId]) VALUES (531, 10, 19)
INSERT INTO [dbo].[RoleAction] ([Id], [RoleId], [ActionId]) VALUES (532, 10, 8)
INSERT INTO [dbo].[RoleAction] ([Id], [RoleId], [ActionId]) VALUES (533, 10, 30)
INSERT INTO [dbo].[RoleAction] ([Id], [RoleId], [ActionId]) VALUES (534, 10, 18)
INSERT INTO [dbo].[RoleAction] ([Id], [RoleId], [ActionId]) VALUES (535, 10, 20)
INSERT INTO [dbo].[RoleAction] ([Id], [RoleId], [ActionId]) VALUES (536, 10, 2)
INSERT INTO [dbo].[RoleAction] ([Id], [RoleId], [ActionId]) VALUES (537, 10, 16)
INSERT INTO [dbo].[RoleAction] ([Id], [RoleId], [ActionId]) VALUES (538, 10, 25)

SET IDENTITY_INSERT [dbo].[RoleAction] OFF